<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="utf-8"/>

<xsl:template match="/MEREPORT">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
		<head>
			<title>Settings</title>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">
					<xsl:value-of select="csspath"/>
				</xsl:attribute>
			</link>
		</head>
		<body>
			<div id="content">		
				<h1>Bluetooth</h1>
				<xsl:apply-templates select="settings/bluetooth"/>
				<h1>Telephony</h1>
				<xsl:apply-templates select="settings/telephony"/>
				<h1>BasicSettings</h1>
				<xsl:apply-templates select="settings/basicSettings"/>
				<h1>Display</h1>
				<xsl:apply-templates select="settings/display"/>
				<h1>Text</h1>
				<xsl:apply-templates select="settings/text"/>
				<h1>Security</h1>
				<xsl:apply-templates select="settings/security"/>
				<h1>Volume</h1>
				<xsl:apply-templates select="settings/volume"/>
				<h1>Internet</h1>
				<xsl:apply-templates select="settings/internet"/>
			</div>
		</body>
	</html>
</xsl:template>

<xsl:template match="bluetooth">
	<table>
		<tr>
			<th>on</th>
			<th>discoverability</th>
			<th>discoverabilityTimeout</th>
		</tr>
		<tr>
			<td><xsl:value-of select="@on"/></td>
			<td><xsl:value-of select="discoverability"/></td>
			<td><xsl:value-of select="discoverabilityTimeout"/></td>
		</tr>
	</table>
</xsl:template>

<xsl:template match="telephony">
	<table>
		<tr>
			<th>dataRoamingEnabled</th>
			<th>networkPreference</th>
			<th>vibrate</th>
		</tr>
		<tr>
			<td><xsl:value-of select="dataRoamingEnabled"/></td>
			<td><xsl:value-of select="networkPreference"/></td>
			<td><xsl:value-of select="vibrate"/></td>
		</tr>
	</table>
</xsl:template>

<xsl:template match="basicSettings">
	<table>
		<tr>
			<th>fontScale</th>
			<th>dtmfTonesWhenDialing</th>
			<th>hours12or24</th>
			<th>installNonMarketApps</th>
			<th>windowAnimationScale</th>
			<th>dateFormat</th>
		</tr>
		<tr>
			<td><xsl:value-of select="fontScale"/></td>
			<td><xsl:value-of select="dtmfTonesWhenDialing"/></td>
			<td><xsl:value-of select="hours12or24"/></td>
			<td><xsl:value-of select="installNonMarketApps"/></td>
			<td><xsl:value-of select="windowAnimationScale"/></td>
			<td><xsl:value-of select="dateFormat"/></td>
		</tr>
	</table>
</xsl:template>

<xsl:template match="display">
	<table>
		<tr>
			<th>dimScreen</th>
			<th>brightness</th>
			<th>screenOffTimeout</th>
		</tr>
		<tr>
			<td><xsl:value-of select="dimScreen"/></td>
			<td><xsl:value-of select="brightness"/></td>
			<td><xsl:value-of select="screenOffTimeout"/></td>
		</tr>
	</table>
</xsl:template>

<xsl:template match="text">
	<table>
		<tr>
			<th>automaticCapsLock</th>
			<th>autoPunctuate</th>
			<th>autoReplace</th>
		</tr>
		<tr>
			<td><xsl:value-of select="automaticCapsLock"/></td>
			<td><xsl:value-of select="autoPunctuate"/></td>
			<td><xsl:value-of select="autoReplace"/></td>
		</tr>
	</table>
</xsl:template>

<xsl:template match="security">
	<table>
		<tr>
			<th>lockPatternVisible</th>
			<th>lockPatternEnabled</th>
			<th>lockPatternTactileFeedbackEnabled</th>
			<th>showPasswords</th>
		</tr>
		<tr>
			<td><xsl:value-of select="lockPatternVisible"/></td>
			<td><xsl:value-of select="lockPatternEnabled"/></td>
			<td><xsl:value-of select="lockPatternTactileFeedbackEnabled"/></td>
			<td><xsl:value-of select="showPasswords"/></td>
		</tr>
	</table>
</xsl:template>

<xsl:template match="volume">
	<table>
		<tr>
			<th>alarm</th>
			<th>music</th>
			<th>ring</th>
			<th>system</th>
			<th>voice</th>
			<th>soundEffectsEnabled</th>
		</tr>
		<tr>
			<td><xsl:value-of select="alarm"/></td>
			<td><xsl:value-of select="music"/></td>
			<td><xsl:value-of select="ring"/></td>
			<td><xsl:value-of select="system"/></td>
			<td><xsl:value-of select="voice"/></td>
			<td><xsl:value-of select="soundEffectsEnabled"/></td>
		</tr>
	</table>
</xsl:template>

<xsl:template match="internet">
	<table>
		<tr>
			<th>httpProxy</th>
			<th>useGoogleMail</th>
			<th>wifiNotifications</th>
			<th>wifiRepeatDelay</th>
			<th>wifiNumberOfOpenNetworksKept</th>
			<th>wifiOn</th>
			<th>useStaticIp</th>
			<th>wifiStaticIp</th>
			<th>wifiStaticMask</th>
			<th>wifiStaticGateway</th>
			<th>wifiStaticDns1</th>
			<th>wifiStaticDns2</th>
			<th>wifiWatchDogOn</th>
		</tr>
		<tr>
			<td><xsl:value-of select="httpProxy"/></td>
			<td><xsl:value-of select="useGoogleMail"/></td>
			<td><xsl:value-of select="wifiNotifications"/></td>
			<td><xsl:value-of select="wifiRepeatDelay"/></td>
			<td><xsl:value-of select="wifiNumberOfOpenNetworksKept"/></td>
			<td><xsl:value-of select="wifiOn"/></td>
			<td><xsl:value-of select="useStaticIp"/></td>
			<td><xsl:value-of select="wifiStaticIp"/></td>
			<td><xsl:value-of select="wifiStaticMask"/></td>
			<td><xsl:value-of select="wifiStaticGateway"/></td>
			<td><xsl:value-of select="wifiStaticDns1"/></td>
			<td><xsl:value-of select="wifiStaticDns2"/></td>
			<td><xsl:value-of select="wifiWatchDogOn"/></td>
		</tr>
	</table>
</xsl:template>

</xsl:stylesheet>

